package edu.uky.ai.csp.kr;

/**
 * Constrains two variables to have different values.
 * 
 * @author Stephen G. Ware
 */
public class NotEqualsConstraint extends Constraint {
	
	/**
	 * Constructs a new not equals constraint object.
	 * 
	 * @param left the left hand side of the constraint
	 * @param right the right hand side of the constraint
	 */
	public NotEqualsConstraint(Variable left, Variable right) {
		super(left, right);
	}
	
	@Override
	public String toString() {
		return "(" + left + " != " + right + ")";
	}

	@Override
	protected boolean testValues(Solution solution, Object left, Object right) {
		return left != right;
	}
}
